//=============================================================================
// UDamage.
//=============================================================================
class xmasUDamage extends UDamage;

#exec mesh import mesh=SantasHat anivfile=Models\SantasHat_a.3d datafile=Models\SantasHat_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=SantasHat x=0 y=0 z=0
#exec mesh sequence mesh=SantasHat seq=All startframe=0 numframes=1

#exec meshmap new meshmap=SantasHat mesh=SantasHat
#exec meshmap scale meshmap=SantasHat x=0.08594 y=0.08594 z=0.17188

#exec AUDIO IMPORT FILE="Sounds\xmasAmp.WAV" NAME="xmasAmp"

var Weapon UDamageWeapon;
var sound ExtraFireSound;
var sound EndFireSound;
var int FinalCount;

singular function UsedUp()
{
	if ( UDamageWeapon != None )
	{
		UDamageWeapon.SetDefaultDisplayProperties();
		if ( UDamageWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDamageWeapon).Affector = None;
	}
	if ( Owner != None )
	{
		if ( Owner.bIsPawn )
		{
			if ( !Pawn(Owner).bIsPlayer || (Pawn(Owner).PlayerReplicationInfo.HasFlag == None) )
			{
				Owner.AmbientGlow = Owner.Default.AmbientGlow;
				Owner.LightType = LT_None;
			}
			Pawn(Owner).DamageScaling = 1.0;
		}
		bActive = false;
		if ( Owner.Inventory != None )
		{
			Owner.Inventory.SetOwnerDisplay();
			Owner.Inventory.ChangedWeapon();
		}
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogItemDeactivate(Self, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogItemDeactivate(Self, Pawn(Owner));
	}
	Destroy();
}

simulated function FireEffect()
{
	if ( (TimerRate - TimerCounter < 5) && (Level.NetMode != NM_Client) )
		Pawn(Owner).Weapon.PlayOwnedSound(EndFireSound, SLOT_Interact, 8);
	else 
		Pawn(Owner).Weapon.PlayOwnedSound(ExtraFireSound, SLOT_Interact, 8);
}

function SetOwnerLighting()
{
	if ( Owner.bIsPawn && Pawn(Owner).bIsPlayer
		&& (Pawn(Owner).PlayerReplicationInfo.HasFlag != None) ) 
		return;
	Owner.AmbientGlow = 254; 
	Owner.LightEffect=LE_NonIncidence;
	Owner.LightBrightness=255;
	Owner.LightHue=210;
	Owner.LightRadius=10;
	Owner.LightSaturation=0;
	Owner.LightType=LT_Steady;
}

function SetUDamageWeapon()
{
	if ( !bActive )
		return;

	SetOwnerLighting();

	// Make old weapon normal again.
	if ( UDamageWeapon != None )
	{
		UDamageWeapon.SetDefaultDisplayProperties();
		if ( UDamageWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDamageWeapon).Affector = None;
	}
		
	UDamageWeapon = Pawn(Owner).Weapon;
	// Make new weapon cool.
	if ( UDamageWeapon != None )
	{
		if ( UDamageWeapon.IsA('TournamentWeapon') )
			TournamentWeapon(UDamageWeapon).Affector = self;
		if ( Level.bHighDetailMode )
			UDamageWeapon.SetDisplayProperties(ERenderStyle.STY_Translucent, 
									 FireTexture'UnrealShare.Belt_fx.UDamageFX',
									 true,
									 true);
		else
			UDamageWeapon.SetDisplayProperties(ERenderStyle.STY_Normal, 
							 FireTexture'UnrealShare.Belt_fx.UDamageFX',
							 true,
							 true);
	}
}

//
// Player has activated the item, pump up their damage.
//
state Activated
{
	function Timer()
	{
		if ( FinalCount > 0 )
		{
			SetTimer(1.0, true);
			Owner.PlaySound(DeActivateSound,, 8);
			FinalCount--;
			return;
		}
		UsedUp();
	}

	function SetOwnerDisplay()
	{
		if( Inventory != None )
			Inventory.SetOwnerDisplay();

		SetUDamageWeapon();
	}

	function ChangedWeapon()
	{
		if( Inventory != None )
			Inventory.ChangedWeapon();

		SetUDamageWeapon();
	}

	function EndState()
	{
		UsedUp();
	}

	function BeginState()
	{
		bActive = true;
		FinalCount = Min(FinalCount, 0.1 * Charge - 1);
		SetTimer(0.1 * Charge - FinalCount,false);
		Owner.PlaySound(ActivateSound);	
		SetOwnerLighting();
		Pawn(Owner).DamageScaling = 3.0;
		SetUDamageWeapon();	
	}
}

defaultproperties
{
     ExtraFireSound=Sound'Botpack.Pickups.AmpFire'
     EndFireSound=Sound'Botpack.Pickups.AmpFire2b'
     FinalCount=5
     PickupMessage="You got Santas hat of power!"
     ItemName="Santas hat of power"
     PickupViewMesh=Mesh'DanesXmas_v2009.SantasHat'
     PickupSound=Sound'DanesXmas_v2009.xmasAmp'
     Texture=None
     Mesh=Mesh'DanesXmas_v2009.SantasHat'
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'DanesXmas_v2009.HatDeco'
     MultiSkins(1)=Texture'DanesXmas_v2009.Red'
     CollisionRadius=17.000000
     CollisionHeight=22.000000
}
